/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.item;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.genetic.AgriGenomeProviderItem;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.registry.ModBlocks;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class TrowelItem
extends class_1792
implements AgriGenomeProviderItem {
    public TrowelItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1269 method_7884(class_1838 context) {
        return AgriApi.getCrop((class_1922)context.method_8045(), context.method_8037()).map(crop -> this.tryUseOnCrop((AgriCrop)crop, context.method_8041(), context.method_8036())).orElseGet(() -> this.tryPlantOnSoil(context.method_8045(), context.method_8037(), context.method_8041(), context.method_8036()));
    }

    protected class_1269 tryUseOnCrop(AgriCrop crop, class_1799 heldItem, class_1657 player) {
        if (crop.hasWeeds()) {
            if (player != null && player.method_37908().method_8608()) {
                player.method_43496((class_2561)class_2561.method_43471((String)"agricraft.message.trowel_weed"));
            }
            return class_1269.field_5814;
        }
        if (crop.isCrossCropSticks()) {
            return class_1269.field_5814;
        }
        if (crop.hasPlant()) {
            return this.tryPickUpPlant(crop, heldItem, player);
        }
        return this.tryPlantOnCropSticks(crop, heldItem, player);
    }

    protected class_1269 tryPickUpPlant(AgriCrop crop, class_1799 stack, class_1657 player) {
        if (crop.method_10997() == null || crop.method_10997().method_8608()) {
            return class_1269.field_5811;
        }
        if (this.hasPlant(stack)) {
            if (player != null) {
                player.method_43496((class_2561)class_2561.method_43471((String)"agricraft.message.trowel_plant"));
            }
            return class_1269.field_5814;
        }
        AgriGenome genome = crop.getGenome();
        if (genome != null) {
            this.setPlant(stack, genome, crop.getGrowthStage());
            crop.removeGenome();
        }
        return class_1269.field_5812;
    }

    protected class_1269 tryPlantOnCropSticks(AgriCrop crop, class_1799 stack, class_1657 player) {
        if (crop.method_10997() == null || crop.method_10997().method_8608()) {
            return class_1269.field_5811;
        }
        if (crop.isCrossCropSticks()) {
            return class_1269.field_5814;
        }
        if (this.hasPlant(stack)) {
            if (crop.hasCropSticks()) {
                this.getGenome(stack).ifPresent(genome -> this.getGrowthStage(stack).ifPresent(growth -> {
                    this.removePlant(stack);
                    crop.plantGenome((AgriGenome)genome, (class_1309)player);
                    crop.setGrowthStage((AgriGrowthStage)growth);
                }));
            }
            return class_1269.field_5812;
        }
        if (player != null) {
            player.method_43496((class_2561)class_2561.method_43471((String)"agricraft.message.trowel_no_plant"));
        }
        return class_1269.field_5814;
    }

    protected class_1269 tryPlantOnSoil(class_1937 level, class_2338 pos, class_1799 stack, class_1657 player) {
        if (this.hasPlant(stack)) {
            return AgriApi.getCrop((class_1922)level, pos.method_10084()).map(crop -> this.tryPlantOnCropSticks((AgriCrop)crop, stack, player)).orElseGet(() -> this.tryNewPlant(level, pos.method_10084(), stack, player));
        }
        return class_1269.field_5814;
    }

    protected class_1269 tryNewPlant(class_1937 world, class_2338 pos, class_1799 stack, @Nullable class_1657 player) {
        CropBlock cropBlock;
        class_2680 newState;
        if (CoreConfig.plantOffCropSticks && world.method_8652(pos, newState = (cropBlock = (CropBlock)ModBlocks.CROP.get()).blockStatePlant(cropBlock.method_9564()), 3)) {
            boolean success = AgriApi.getCrop((class_1922)world, pos).map(crop -> this.getGenome(stack).map(genome -> this.getGrowthStage(stack).map(stage -> {
                crop.plantGenome((AgriGenome)genome, (class_1309)player);
                crop.setGrowthStage((AgriGrowthStage)stage);
                this.removePlant(stack);
                return true;
            }).orElse(false)).orElse(false)).orElse(false);
            if (success) {
                return class_1269.field_5812;
            }
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
        return class_1269.field_5814;
    }

    public void setPlant(class_1799 stack, AgriGenome genome, AgriGrowthStage stage) {
        if (this.hasPlant(stack)) {
            return;
        }
        this.setGenome(stack, genome);
        class_2487 tag = stack.method_7948();
        tag.method_10569("growthIndex", stage.index());
        tag.method_10569("growthTotal", stage.total());
    }

    public void removePlant(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            tag.method_10551("growthIndex");
            tag.method_10551("growthTotal");
            AgriGenome.removeFromNBT(tag);
        }
    }

    public boolean hasPlant(class_1799 itemStack) {
        return this.getGenome(itemStack).isPresent();
    }

    public Optional<AgriGrowthStage> getGrowthStage(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10545("growthIndex") && tag.method_10545("growthTotal")) {
            int growthIndex = tag.method_10550("growthIndex");
            int growthTotal = tag.method_10550("growthTotal");
            return Optional.of(new AgriGrowthStage(growthIndex, growthTotal));
        }
        return Optional.empty();
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        AgriGenome genome;
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"agricraft.tooltip.trowel").method_27692(class_124.field_1063));
        class_2487 tag = stack.method_7969();
        if (tag != null && (genome = AgriGenome.fromNBT(tag)) != null) {
            genome.appendHoverText(tooltipComponents, (class_1836)class_1836.field_41071);
        }
    }
}

